using ConnectorLib.JSON;
using CrowdControl.Harmony;
using Rewired;
using UnityEngine;

namespace CrowdControl.Delegates.Effects.Implementations
{
    [Effect(new[] { "camera_invert_x", "camera_perspective" }, 30, true)]
    public class CameraEffects : Effect
    {
        public CameraEffects(CrowdControl mod, NetworkClient client) : base(mod, client) { }
        
        public override EffectResponse Start(EffectRequest request) => Resume(request) ?? EffectResponse.Success(request.ID);

        public override EffectResponse Pause(EffectRequest request) => Stop(request);

        public override EffectResponse Resume(EffectRequest request)
        {
            Camera camera = Camera.main;
            if (camera == null)
                return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Main camera not found.");

            CameraManager cameraManager = Manager.camera;
            if (cameraManager == null)
                return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Camera manager not found.");

            switch (request.code)
            {
                case "camera_perspective":
                {
                    camera.orthographic = false;
                    camera.fieldOfView = 25f;
                    break;
                }
                case "camera_invert_x":
                {
                    CameraFlip.Enabled = true;
                    Matrix4x4 v = camera.worldToCameraMatrix;
                    v[0, 0] = -v[0, 0];
                    v[0, 1] = -v[0, 1];
                    v[0, 2] = -v[0, 2];
                    v[0, 3] = -v[0, 3];
                    camera.worldToCameraMatrix = v;
                    GL.invertCulling = true;
                    break;
                }
            }
            

            return null;
        }

        public override EffectResponse Stop(EffectRequest request)
        {
            Camera camera = Camera.main;
            if (camera == null)
                return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Main camera not found.");

            CameraManager cameraManager = Manager.camera;
            if (cameraManager == null)
                return EffectResponse.Failure(request.ID, StandardErrors.GameObjectNotFound, "Camera manager not found.");

            switch (request.code)
            {
                case "camera_perspective":
                {
                    camera.orthographic = true;
                    camera.fieldOfView = 60f;
                    break;
                }
                case "camera_invert_x":
                {
                    CameraFlip.Enabled = false;
                    camera.ResetWorldToCameraMatrix();
                    GL.invertCulling = false;
                    break;
                }
            }

            return null;
        }
    }
}